﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="AllActivities.ascx.cs" Inherits="GUI.Pages.DashboardControls.AllActivities" %>
<telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" EnableAJAX="true" LoadingPanelID="RadAjaxLoadingPanel1">
<telerik:RadGrid ID="grdList" GroupingSettings-CaseSensitive="false" runat="server" PageSize="5" AllowFilteringByColumn="true"  CssClass="kendo-table" Skin="Bootstrap"
    OnItemCommand="grdList_OnItemCommand" AllowPaging="true" AllowSorting="true"
    OnNeedDataSource="grdList_OnNeedDataSource" OnColumnCreating="grdList_OnColumnCreating">
    <PagerStyle Mode="NextPrevAndNumeric" />
    <MasterTableView ShowHeadersWhenNoRecords="true" TableLayout="Auto" ShowFooter="False" CssClass="table table-striped table-hover"
        AutoGenerateColumns="False" DataKeyNames="Id">
        <Columns>
            
            <telerik:GridBoundColumn UniqueName="NameColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="Contains"
                SortExpression="Name" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, Common_Name %>" DataField="Name" />
            
            <telerik:GridBoundColumn UniqueName="ProjectColumn" HeaderStyle-Width="150" AutoPostBackOnFilter="true"
                CurrentFilterFunction="Contains" SortExpression="Project.Name" ShowFilterIcon="false"
                HeaderText="<%$ Resources:ProjectManagementUI, Common_Project %>" DataField="Project.Name" />
            
			<telerik:GridBoundColumn UniqueName="Assigned" HeaderStyle-Width="150" AutoPostBackOnFilter="true"
                CurrentFilterFunction="Contains" SortExpression="UsersDisplayString" ShowFilterIcon="false"
                HeaderText="<%$ Resources:ProjectManagementUI, UI_Users %>" DataField="UsersDisplayString" >
</telerik:GridBoundColumn>
            <telerik:GridBoundColumn UniqueName="StartDateColumn" HeaderStyle-Width="70" AutoPostBackOnFilter="true"
                CurrentFilterFunction="Contains" SortExpression="StartDateLocalized" ShowFilterIcon="false"
                HeaderText="<%$ Resources:ProjectManagementUI, Common_Start %>" DataField="StartDateLocalized" />
			
            <telerik:GridBoundColumn UniqueName="EndDateColumn" HeaderStyle-Width="70" AutoPostBackOnFilter="true"
                CurrentFilterFunction="Contains" SortExpression="EndDateLocalized" ShowFilterIcon="false"
                HeaderText="<%$ Resources:ProjectManagementUI, Common_End %>" DataField="EndDateLocalized" />
			
            <telerik:GridTemplateColumn AllowFiltering="false" HeaderStyle-Width="70" HeaderText="<%$ Resources:ProjectManagementUI, Common_PriorityShort %>" UniqueName="PriorityColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="StartsWith" SortExpression="EnumPriority.NameLocalized" >
				<ItemTemplate>
                    <i class="fa fa-arrow-circle-<%#(Eval("EnumPriority.Name").ToString() == "Medium" ? "right font-kendo-yellow" : "")%><%#(Eval("EnumPriority.Name").ToString() == "High" ? "up font-kendo-red" : "")%><%#(Eval("EnumPriority.Name").ToString() == "Low" ? "down font-kendo-green" : "")%>"></i>
				</ItemTemplate>
				<ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
			</telerik:GridTemplateColumn>
            
            <telerik:GridTemplateColumn AllowFiltering="false" HeaderStyle-Width="95" HeaderText="<%$ Resources:ProjectManagementUI, UI_Finished %>" UniqueName="IsClosed" AutoPostBackOnFilter="true" CurrentFilterFunction="StartsWith" SortExpression="Progress" >
				<ItemTemplate>
                      <i class="fa fa-1x fa-<%# (Eval("IsClosed").ToString() == "True") ? "check-square font-kendo-green" : "check-square font-kendo-red" %>"></i>  
				</ItemTemplate>
				<ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
			</telerik:GridTemplateColumn>
						
			<telerik:GridTemplateColumn AllowFiltering="false" HeaderStyle-Width="95" HeaderText="<%$ Resources:ProjectManagementUI, Common_Progres %>" UniqueName="ProgressColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="StartsWith" SortExpression="Progress" >
				<ItemTemplate>
				   <div class="progress">
                        <div class="progress-bar bg-kendo-<%# Convert.ToInt32(Eval("Progress")) <= 20 ? "red" : "" %><%# Convert.ToInt32(Eval("Progress")) > 20  && Convert.ToInt32(Eval("Progress")) <= 99 ? "blue" : "" %><%# Convert.ToInt32(Eval("Progress")) > 99 ? "green" : "" %>" role="progressbar" aria-valuenow="<%# Eval("Progress") %>" aria-valuemin="0" aria-valuemax="100" style="width: <%# Eval("Progress") %>%">
                                <span class=""> <%# Eval("Progress") %>% </span>
                        </div>
                    </div> 
			    </ItemTemplate>
				<ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
			</telerik:GridTemplateColumn>
			
				<telerik:GridTemplateColumn AllowFiltering="false" HeaderStyle-Width="40">
				<ItemTemplate>
					<a class="btn btn-xs btn-primary font-white" href="<%= getVirtualPath() %>/Pages/Activity.aspx?aid=<%# Eval("Id") %>"><i class="fa fa-edit"></i></a>
				</ItemTemplate>
				<ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
			</telerik:GridTemplateColumn>
        </Columns>
    </MasterTableView>
</telerik:RadGrid>
</telerik:RadAjaxPanel>
<telerik:RadAjaxLoadingPanel runat="server" ID="RadAjaxLoadingPanel1">
        <div class="updatePanelProgress">
            <asp:Literal ID="ltrPLeaseWait" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_PleaseWait %>" />...</div>
    </telerik:RadAjaxLoadingPanel>
